/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.impl;

import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.core.model.IParent;
import com.aptana.editor.php.internal.builder.BuildPathManager;
import com.aptana.editor.php.internal.builder.ProjectBuildPath;
import com.aptana.editor.php.internal.builder.WorkspaceFolderBuildpath;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IBuildPathResource;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.model.impl.AbstractModelElement;
import com.aptana.editor.php.internal.model.impl.SourceFolder;
import com.aptana.editor.php.internal.model.impl.SourceProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractResourceElement
extends AbstractModelElement
implements IParent {
    private IBuildPathResource resource;

    protected AbstractResourceElement(IBuildPathResource resource) {
        this.resource = resource;
    }

    public boolean exists() {
        IBuildPath buildPath = this.resource.getBuildPath();
        if (buildPath == null) {
            return false;
        }
        if (!this.buildPathExists(buildPath)) {
            return false;
        }
        if (this.resource instanceof IDirectory) {
            return buildPath.getDirectoryByPath(this.resource.getPath()) != null;
        }
        if (this.resource instanceof IModule) {
            return buildPath.getModuleByPath(this.resource.getPath()) != null;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractResourceElement other = (AbstractResourceElement)obj;
        return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
    }

    public String getElementName() {
        return this.resource.getShortName();
    }

    public IModelElement getParent() {
        IBuildPath buildPath = this.resource.getBuildPath();
        if (buildPath == null) {
            return null;
        }
        IPath modulePath = this.resource.getPath();
        IPath directoryPath = modulePath.removeLastSegments(1);
        if (directoryPath.segmentCount() == 0) {
            if (buildPath instanceof ProjectBuildPath) {
                return new SourceProject((ProjectBuildPath)buildPath);
            }
            if (buildPath instanceof WorkspaceFolderBuildpath) {
                IFolder folder = ((WorkspaceFolderBuildpath)buildPath).getFolder();
                IProject prj = folder.getProject();
                IBuildPath prjBuildPath = BuildPathManager.getInstance().getBuildPathByResource(prj);
                if (prjBuildPath == null) {
                    return null;
                }
                IDirectory dir = prjBuildPath.getDirectory((Object)folder);
                if (dir == null) {
                    return null;
                }
                return new SourceFolder(dir);
            }
            return null;
        }
        IDirectory directory = buildPath.getDirectoryByPath(directoryPath);
        if (directory == null) {
            return null;
        }
        return new SourceFolder(directory);
    }

    public String toString() {
        return this.toDebugString();
    }

    protected IBuildPathResource getBPResource() {
        return this.resource;
    }

    private boolean buildPathExists(IBuildPath buildPath) {
        if (buildPath instanceof ProjectBuildPath) {
            return ((ProjectBuildPath)buildPath).getProject().exists();
        }
        if (buildPath instanceof WorkspaceFolderBuildpath) {
            return ((WorkspaceFolderBuildpath)buildPath).getFolder().exists();
        }
        return true;
    }
}

